import React, { useState, useRef, useEffect } from 'react';

import { SitePal } from 'sitepal-react-v2';

function Char3D() {

    const [textToSay, setTextToSay] = useState('');
    const [iframeContent, setIframeContent] = useState('');
    const frameContentRef = useRef(null);
    const myButtonRef = useRef(null);

    useEffect(() => {
        window.vh_aiResponse = (aiString) => {
            if (!textToSay.trim()) {
                console.error('Input is empty');
                return;
            }

            const aiResponse = aiString;

            const updatedIframeContent = `<br><font color="#FF0000">Q - ${textToSay}</font><br><font color="#0000FF">A - ${aiResponse}</font>${iframeContent}`;
            setIframeContent(updatedIframeContent);

            // Update iframe content
            if (frameContentRef.current) {
                frameContentRef.current.contentDocument.open();
                frameContentRef.current.contentDocument.write(
                    `<html><body bgcolor="#FFFFFF">${updatedIframeContent}</body></html>`
                );
                frameContentRef.current.contentDocument.close();
            }

            // Clear the input field
            setTextToSay('');

            // Restore button opacity and pointer events
            if (myButtonRef.current) {
                myButtonRef.current.style.opacity = '1';
                myButtonRef.current.style.pointerEvents = 'unset';
            }
        };
    }, [textToSay, iframeContent]);

    const aiFunction = () => {
        if (textToSay.trim() !== '') {
            if (myButtonRef.current) {
                myButtonRef.current.style.opacity = '0.5';
                myButtonRef.current.style.pointerEvents = 'none';
            }
        }
    };

    const sayAudio = (e) => {
        e.preventDefault();
        const trimmedText = textToSay.trim();
        window.sayAI(trimmedText, 1, 1, 3);
        aiFunction();
    };



    return (
        <div>
            <header className="main_header">
                <div className="left_div">
                    <div className="logo logo_heading">
                        <a href="/"><img src="https://www.sitepal.com/api/examples/images/logo.png" alt="SitePal" /></a>
                    </div>
                </div>
            </header>

            <table id="tblContainer" cellSpacing="0" align="center" border="0">
                <tbody>
                    <tr>
                        <td id="tdContent">
                            <p className="feature_entire_heading text-center f-bold h2" align="center"><b>AI Agent With Text Input - Using React JS </b></p>
                            <p className="feature_entire_heading text-center" align="center">In this example we demonstrate an AI Agent that
                                responds to text input. <br /> Read our <a className="selected_support" href="/docs/Implementing_Your_AI_Agent.pdf" target="_blank">technical note</a> to learn more. </p>

                            <table width="100%" border="0" cellSpacing="0" cellPadding="0">
                                <tbody>
                                    <tr>
                                        <td align="center" colSpan="2" className="feature_entire_heading text-center sayAi">
                                            {/* <!-- ******************************* SITEPAL EMBED CODE START  ***********************  --> */}
                                            <SitePal embed='16851,360,480,"",1,1, 2695840, 0,1,1,"5c6fde06460aa8ab405bf4f13cf93cf0",0' />
                                            {/* <!-- ******************************* SITEPAL EMBED CODE END  ***********************  --> */}
                                            <br />

                                            <form name="myForm" className="form" onSubmit={sayAudio}>
                                                <input name="textToSay" id="myInput" value={textToSay} onChange={(e) => setTextToSay(e.target.value)} v-model="textToSay" className="form-control d-inline w-25" />
                                                <input type="submit" id="myButton" ref={myButtonRef} value="Ask AI Engine"
                                                    className="btn btn-primary" /><br /><br />

                                                <br /><br />
                                            </form>
                                            <iframe id="simple-content" ref={frameContentRef} align="top" height="200" width="400"></iframe>
                                        </td>

                                    </tr>
                                    <tr align="middle">
                                        <td align="center" colSpan="2" className="feature_entire_heading text-center">
                                            <p>Real-time Artificial Intelligence Engine provides automatic Text and
                                                Audio responses to the questions provided. </p>
                                            <p>The Audio is generated automatically via a Text To Speech engine according to the selected voice and
                                                language.</p><br />
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
            <footer>
                <div className="footer-menu oddcast text-center">
                    <ul className="w-50 m-auto ">
                        <li className="w-100 f-bold ">Please feel free to use the source code of this page as an example.</li>
                        <li>To view the source code of this page, <a href="/api/examples/react-ai-text/Sitepal-react-text-ai.zip"
                            download="">download </a> 
                            source code</li>
                    </ul>
                </div>
            </footer>
        </div>
    );
}
export default Char3D;